@extends('admin.layouts.app')

@section('title', 'Data Karyawan')

@section('content')

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1">Data Karyawan</h4>
            <small class="text-muted">Manajemen data karyawan</small>
        </div>

        {{-- <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#tambahKaryawan">
            <i class="fas fa-plus me-2"></i>Tambah Data
        </button> --}}
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">

            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Nama</th>
                        <th>tanggal</th>
                        <th>Jam Masuk</th>
                        <th>Jam Pulang</th>
                        <th>latitude</th>
                        <th>longitude</th>
                        <th>Foto Masuk</th>
                        <th>Foto Pulang</th>
                        <th>Wajah Valid</th>
                        <th>Status</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($absensi as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->karyawan->user->nama ?? '-' }}</td>
                            <td>{{ $item->tanggal ?? '-' }}</td>
                            <td>{{ $item->jam_masuk ?? '-' }}</td>
                            <td>{{ $item->jam_pulang ?? '-' }}</td>
                            <td>{{ $item->latitude ?? '-' }}</td>
                            <td>{{ $item->longitude ?? '-' }}</td>
                            <td>{{ $item->foto_masuk ?? '-' }}</td>
                            <td>{{ $item->foto_pulang ?? '-' }}</td>
                            <td>{{ $item->face_valid ?? '-' }}</td>
                            <td>
                                <span class="badge {{ $item->status == 'hadir' ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $item->status }}
                                </span>
                            </td>
                            <td class="text-center">
                                {{-- <button data-bs-target="#ubahKaryawan{{ $item->id }}" data-bs-toggle="modal"
                                    class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                    data-bs-target="#hapusKaryawan{{ $item->id }}">
                                    <i class="fas fa-trash"></i>
                                </button> --}}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
        @foreach ($karyawan as $item)
            {{-- @include('admin.karyawan.edit')
            @include('admin.karyawan.delete') --}}
        @endforeach
    </div>
    {{-- @include('admin.karyawan.create') --}}


@endsection
